/* Copyright 2001, Christian Collberg, collberg@cs.arizona.edu. */

import java.io.*;
import java.util.*;

public class Compiler {

    // The first argument should be '-ir' or '-mips'.
    // The second argument should be the name of the source
    // code file.
    public static void main (String args[]) throws IOException {
        String what = args[0];
        String file = args[1];
        Lex scanner = new Lex(file);
        Parse parser = new Parse(scanner);
        Sem sem = new Sem(parser.ast);
        Opt opt = new Opt(sem);
        GenIR ir = new GenIR(opt.sem);

        if (what.equals("-ir"))
           ir.write();
        else if (what.equals("-mips")) {
           GenMips mips = new GenMips(ir.code);
           System.out.println(mips.code);
        }
   }

}
