/** Token.java
 *
 *  A Vector of these is returned by SExpressionParser.parse(InputStream).
 * 
 *  You can change it if you like, but you'll have to change the code
 *  that generates them, too.
 */
public class SExprToken
{
  // constants for token types
  public static final Object INT = "INT",
    STR    = "STR",
    REAL   = "REAL",
    ATOM   = "ATOM",
    
    // these ones you don't need to use
    LPAREN = "LPAREN", RPAREN = "RPAREN", NONE = "NONE",
    STR_BS = "STR_BS", DOT = "DOT", REAL_E = "REAL_E", EOF = "EOF",
    REAL_E_DIGIT = "REAL_E_DIGIT", REAL_E_SIGN = "REAL_E_SIGN";
  
  public static SExprToken EPSILON = new SExprToken(SExprToken.NONE, "Epsilon");
  
  
  // instance variables
  public Object kind;
  public String value;
  
  public SExprToken(Object kind, String value)
  {
    this.kind = kind;
    this.value = value;
  }
  
  public String toString()
  {
    if (kind == STR)
      return "\"" + value + "\"";
    else
      return value;
  }
}
