#include <stdio.h>
#include <string.h>
#include "sexpr.h"

void print_SExpr(SExpr* sexpr){
   if (sexpr==NULL){
      printf("()");
      return;
   }

   if (TYPE(sexpr)==ATOM_TYPE){
      printf("%s", VALUE(sexpr));
   }else{
      SExpr* curr;

      printf("(");
      print_SExpr(CAR(sexpr));
      for (curr=CDR(sexpr);curr!=NULL;curr=CDR(curr)){
         printf(" ");
         print_SExpr(CAR(curr));
      }
      printf(")");
   }
}

SExpr* make_List(SExpr* car, SExpr* cdr){
   SExpr* result = (SExpr*)malloc(sizeof(SExpr));
   TYPE(result) = LIST_TYPE;
   CAR(result)  = car;
   CDR(result)  = cdr;
   
   return result;
}

SExpr* make_Atom(char *value){
   SExpr* result = (SExpr*)malloc(sizeof(SExpr));
   TYPE(result)  = ATOM_TYPE;
   VALUE(result) = strdup(value);
   return result;
}

void free_SExpr(void* data){
   SExpr* sexpr;
   if (data==NULL)
      return;

   sexpr=(SExpr*)data;
   if (TYPE(sexpr)==ATOM_TYPE){
      free(VALUE(sexpr));
   }else{
      free_SExpr(CAR(sexpr));
      free_SExpr(CDR(sexpr));
   }
   free(sexpr);
}

//////////////////

static char buffer[1024];
static int START, END;
static int CURR_CHAR;

#define ISWHITE(ch)         ((ch)=='\t' || (ch)=='\r' || (ch)==' ' || (ch)=='\n')
#define skip_white(infile)  {while(ISWHITE(CURR_CHAR)){ next_char((infile));}}

int next_char(FILE *infile){
   if (START==END){
      START=0;
      END = fread(buffer,1,1023,infile);
   }

   if (END==0 && feof(infile))
      return (CURR_CHAR=(-1));
   else
      return (CURR_CHAR=(0xFF&buffer[START++]));
}


static int parseR(FILE *infile, SExpr **result){
   skip_white(infile);

   if (CURR_CHAR==(-1)){
      return 0;
   }

   if (CURR_CHAR=='('){
      List *list = NULL;
      List *iter;
      SExpr *temp;

      next_char(infile);
      skip_white(infile);

      if (CURR_CHAR==')'){
         (*result) = NULL;
         next_char(infile);
         return 1;
      }

      while (CURR_CHAR!=')'){
         if (CURR_CHAR==(-1)){
            free_List(list, free_SExpr);
            return 0;
         }

         if (!parseR(infile, &temp)){
            free_List(list, free_SExpr);
            return 0;
         }
         list = prepend_List(list, temp);

         skip_white(infile);
      }
      next_char(infile);
      
      temp = NULL;
      FOREACH(iter,list){
         temp = make_List((SExpr*)DATA(iter), temp);
      }
      free_List(list,NULL);
      
      (*result) = temp;
      return 1;

   }else if (CURR_CHAR==')'){
      return 0;
   }else{
      char value[1024];
      int length=0;

      while(CURR_CHAR!=')' && !ISWHITE(CURR_CHAR) && CURR_CHAR!=-1){
         value[length++] = CURR_CHAR;
         next_char(infile);
      }
      value[length] = '\0';

      (*result) = make_Atom(value);
      return 1;
   }
}

int parse(char *filename, SExpr **result){
   int status;
   FILE *infile = fopen(filename, "rt");
   if (infile==NULL)
      return 0;
   
   START=END=0;
   
   next_char(infile);
   status = parseR(infile, result);
   fclose(infile);
   return status;
}


/////////////////////////////////

List* prepend_List(List *list, void *data){
   List *result = (List*)malloc(sizeof(List));
   DATA(result) = data;
   NEXT(result) = list;
   return result;
}

List* append_List(List *list, void *data){
   List *result = (List*)malloc(sizeof(List));
   List *temp;

   DATA(result) = data;
   NEXT(result) = NULL;

   if (list==NULL)
      return list;
   
   for (temp=list;temp->next!=NULL;temp=NEXT(temp)){}
   NEXT(temp) = result;

   return list;
}

void free_List(List *list, void (*freer)(void*)){
   List *curr=list;

   while(curr!=NULL){
      List *temp = curr;
      curr = NEXT(curr);
      if (freer!=NULL)
         freer(DATA(temp));
      free(temp);
   }
}

int length_List(List *list){
   int i=0;
   List *iter;
   FOREACH(iter,list){i++;}
   return i;
}
